//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Filters.h"
#pragma package(smart_init)

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------
TFilter::TFilter(float F1, float F2)
{ /*   
      
     F1 -   
     F2 -   
  */
   F0=(F1+F2)/2;
   N= fabs(3.0*M_PI/(F2-F1));
   if(N%2)N=N+1;
   if(N>256)N=256;
   Z=new float[N+1];
   B=new float[N+1];
   memset(Z,0.0,N*sizeof(float)); memset(B,0.0,N*sizeof(float));

   //  -
   float G=0.0;
   for(int n=0; n<N; n++)
   {
    float t=n-N/2;
    B[n]=0.42+0.5*cos(TWOPI*t/N)+0.08*cos(2*TWOPI*t/N);   // -
    B[n]=B[n]*sin(TWOPI*F0*n);
    G+=fabs(B[n]);
   }
   for(int n=0; n<N; n++) B[n]=B[n]/G;
}
//------------------------------------------------------------------------------
TFilter::~TFilter()
{
  delete[] Z; delete[] B;
}
//------------------------------------------------------------------------------
void TFilter::filter(float * x, int n, float * y)
{ /*  
     x[] -  
     n   -  
     y[] -  
  */
  for(int i=0; i<n; i++)
  {
    memmove(&Z[1],Z,(N-1)*sizeof(float));
    Z[0]=x[i];
    float sum=0.0;
    for(int k=0; k<N; k++) sum+=Z[k]*B[k];
    y[i]=sum;
  }
}
//------------------------------------------------------------------------------
float TFilter::filter(float x)
{ /*  
     x[] -  
     n   -  
     y[] -  
  */
    memmove(&Z[1],Z,(N-1)*sizeof(float));
    Z[0]=x;
    float sum=0.0;
    for(int k=0; k<N; k++) sum+=Z[k]*B[k];
    return sum;
}
//------------------------------------------------------------------------------
float TFilter::getF0(void)
{
     return (F0);
}
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////


TIIRLPF::TIIRLPF(float Fs, int Nz)
{ /*
     Fs -   
     Nz - - 
   */
   long double alfa=exp(-2*M_PI*Fs);
   A=1.0-alfa;
   B=alfa;
   N=Nz;
   Y=new long double[N];
   memset(Y,0,N*sizeof(long double));
}
//------------------------------------------------------------------------------
TIIRLPF::~TIIRLPF()
{
  delete[] Y;
}
//------------------------------------------------------------------------------
long double TIIRLPF::filter(long double x)
{
   long double y=0;
   Y[0]=A*x+B*Y[0];
   for(int i=1; i<N;i++) Y[i]=A*Y[i-1]+B*Y[i];
   y=Y[N-1];
   return y;
}
//------------------------------------------------------------------------------
float TIIRLPF::filter(float * x, int n)
{
   double Gain=0;
   for (int i=0; i<n; i++)
   {
      x[i]=filter(x[i]);
   }
   return Gain;
}
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
TIIRBPF2::TIIRBPF2(float Fc, float BW)
{
 // Fc -   
 // BW -    0.707  0...0,5
 double K, R;
 R=1-3*BW;
 K=(1-2*R*cos(2*M_PI*Fc)+R*R)/(2-2*cos(2*M_PI*Fc));
 A0=1-K;
 A1=2*(K-R)*cos(2*M_PI*Fc);
 A2=R*R-K;
 B1=2*R*cos(2*M_PI*Fc);
 B2=-R*R;
 X2=X1=X0=0;
 Y2=Y1=Y0=0;
 ph=M_PI/512.0;
 dph=2*M_PI*Fc;
 f0=Fc;
 ddph=0.0;
}
//------------------------------------------------------------------------------
float TIIRBPF2::filter(float x)
{
 X2=X1; X1=X0; X0=x;
 Y2=Y1; Y1=Y0;
 Y0=A0*X0+A1*X1+A2*X2+B1*Y1+B2*Y2;
 return Y0;
}
//------------------------------------------------------------------------------
float TIIRBPF2::filter(float x[], int n, float y[])
{
 for(int i=0; i<n; i++) y[i]=filter(x[i]);
 return y[n-1];
}
//------------------------------------------------------------------------------

TCIC4::TCIC4()
{
   Y1[0]=Y1[1]=Y1[2]=Y1[3]=0;
   Z1[0]=Z1[1]=Z1[2]=Z1[3]=0;
   Z2[0]=Z2[1]=Z2[2]=Z2[3]=0;
}

double TCIC4::pre_decim(double x)
{ //     
  double y=0;
  Y1[0]=Y1[0]+x;
  Y1[1]=Y1[1]+Y1[0];
 // Y1[2]=Y1[2]+Y1[1];
 // Y1[3]=Y1[3]+Y1[2];
 // y=Y1[3];
 y=Y1[1];
  return y;
}

double TCIC4::post_decim(double x)
{ //     
  double y=0;
  Z2[0]=Z1[0];
  Z2[1]=Z1[1];
  Z2[2]=Z1[2];
  Z2[3]=Z1[3];
  y=x-Z2[0]; Z1[0]=x; Z1[1]=y;
  y=y-Z2[1]; Z1[2]=y;
 // y=y-Z2[2]; Z1[3]=y;
 // y=y-Z2[3]; 
  return y;
}
